﻿/**
	VERSION:		1.1
	
	FUNCTIONS
		addContextItem()				Adds a menu item / replaces duplicate menu item with a new one
		removeContextItem()			Removes one or all menu items for a movieClip
	
		What this is for
This function makes it a little easier to assign contextual menus to movieClips.


		Advantages:
- Easy to remove a menu item
- Easy to remove all menu items in a movieClip
- Menu items can be replaced.  	(if their labels are the same)
- Don't have to type   new ContextMenu()   for every single movieClip.  (done automatically)
- Use via a shorter & more intuitive line of code
	

		Function Examples
addContextItem( "Label", target_mc, callFunction, [seperator] );
addContextItem( "Hello Werld!?", my_mc, my_mc.myFunct );					Adds a contextual menu item to a movieClip.
addContextItem( "Hello Werld!?", my_mc, my_mc.myFunct, true );		Adds an item & puts a seperator above it.

removeContextItem( "Label", target_mc );
removeContextItem( "funct2()", this );		// Removes a contextual menu item
removeContextItem( null, target_mc );			// Removes ALL contextual menu items in target_mc
*/



// FUNCTIONS
_global.addContextItem = function( label, target_mc, callFunction, seperator )
{
	//trace("addContextItem()");
	//trace("label: "+label);
	//trace("target_mc: "+target_mc);
	//trace("callFunction: "+callFunction);
	
	var seperator = (seperator) ? seperator : false;		// default = no seperator
	
	// Create new menu for this movieClip if neccessary
	if (target_mc.menu == undefined)
	{
		target_mc.menu = new ContextMenu();
		target_mc.menu.hideBuiltInItems();
	}//if (undefined)
	var thisMenu = target_mc.menu;
	
	// If this item already exists, delete it
	for (var i = 0; i < thisMenu.customItems.length; i++)
	{
		var readLabel = thisMenu.customItems[i].caption;
		if (readLabel == label)
		{
			thisMenu.customItems.splice( i, 1);		// delete
		}// if (readLabel)
	}// for...in  (thisMenu.customItems)
	
	// Add a new item to this movieClip's contextual menu
	var newItem = new ContextMenuItem( label, callFunction, seperator);
	thisMenu.customItems.push( newItem );
	
}// addContextItem()



_global.removeContextItem = function( label, target_mc )
{
	// find the specified context menu item
	thisMenu = target_mc.menu.customItems;
	//trace("label: "+label);
	for (var i=0; i < thisMenu.length; i++)
	{
		//trace("thisMenu[i].caption: "+thisMenu[i].caption);
		if (thisMenu[i].caption == label  ||  label==undefined)
		{
			// delete it
			thisMenu.splice( i, 1 );
		}// if (   == label)
	}// for i
	
}// removeContextItem()


